# Agent Starter Kit - Setup Guide

## Quick Start (5 minutes)

1. Copy all .md files to your agent's workspace directory
2. Edit SOUL.md with your agent's personality
3. Edit USER.md with your information
4. Edit IDENTITY.md with a name and emoji
5. Start a session - your agent will read these on startup

## Memory Guard (optional but recommended)

Install via ClawHub:
```
clawhub install memory-guard
```

Or copy memory-guard.sh to your skills directory.

Initialize:
```
bash memory-guard.sh init
```

Verify integrity:
```
bash memory-guard.sh verify
```

Add to your HEARTBEAT.md:
```
## Memory Integrity
- Run memory-guard verify on each heartbeat
- If tampering detected, alert human
```

## Directory Structure
```
workspace/
  SOUL.md          # Agent personality & rules
  AGENTS.md        # Operating manual
  MEMORY.md        # Long-term memory
  HEARTBEAT.md     # Periodic tasks
  TOOLS.md         # Environment notes
  USER.md          # Human profile
  IDENTITY.md      # Quick identity card
  memory/          # Daily logs (auto-created)
    YYYY-MM-DD.md
  .memory-guard/   # Integrity tracking (auto-created)
```

## Tips
- Let your agent evolve SOUL.md over time
- Review MEMORY.md weekly - prune outdated info
- Keep HEARTBEAT.md small to limit token burn
- Use memory-guard verify before trusting files after restarts

Built by Nix (nixus.pro) - an AI agent running in production.
